from visual import *
from visual.graph import *

from SpinLattice import *


class VisualGraph:
    def __init__(self, nSpinsX, nSpinsY, stripeSpacingX, stripeSpacingY, k):
        self.window = display(title='Angle Plot', width=720, height=400, x=150, y=200, center=(0,0,0), background=(.0,.0,.0))
        self.window.fov = pi/900.0
        self.window.lights = [vector(.5,.5,.5), vector(-.5,-.5,-.5)]
        self.window.up = (0.0,0.001,1.0)
        self.window.forward = (0.0,1.0,0.0)


        self.window.autoscale = 0
        self.window.visible = 1
        self.window.select()


        self.tvGraphs = 0
        
##        self.angleCurveA = gcurve(color=color.red, visible=self.tvGraphs)
##        self.angleCurveB = gcurve(color=color.green, visible=self.tvGraphs)
##        self.angleCurveC = gcurve(color=color.blue, visible=self.tvGraphs)

        self.nSpinsX = nSpinsX
        self.nSpinsY = nSpinsY

        self.window.range = self.nSpinsX/2.0
        self.window.center = (-.5,0.0,0.0)

        self.stripeSpacingX = stripeSpacingX
        self.stripeSpacingY = stripeSpacingY

        self.k = k

        self.SpinLattice = SpinLattice(nSpinsX, nSpinsY, k)

        self.xComponentGraph = curve(x=arange(-self.nSpinsX/2.0,self.nSpinsX/2.0,1.0),y=0.0,radius=0.002*self.nSpinsX,color=color.yellow)
        self.yComponentGraph = curve(x=arange(-self.nSpinsX/2.0,self.nSpinsX/2.0,1.0),y=0.0,radius=0.002*self.nSpinsX,color=color.red)
        self.zComponentGraph = curve(x=arange(-self.nSpinsX/2.0,self.nSpinsX/2.0,1.0),y=0.0,radius=0.002*self.nSpinsX,color=color.blue)
        self.xyzComponentGraph = curve(x=arange(-self.nSpinsX/2.0,self.nSpinsX/2.0,1.0),y=0.0,radius=0.002*self.nSpinsX,color=color.green)
          
    def updateGraph(self,nLattice,t):
        self.SpinLattice.updateVectors(nLattice)
        spinLattice = self.SpinLattice.returnSpinLattice()
        
#        componentA = float(spinArray[0][0][0][0])
##        componentB = float(spinArray[0][1][0][0])
#        componentC = float(spinArray[0][0][0][2])

##        if abs(dotA) < 1.0:     diffAngleA = arccos(dotA)
##        else:                   diffAngleA = pi
##        if abs(dotB) < 1.0:     diffAngleB = arccos(dotB)
##        else:                   diffAngleB = pi
##        if abs(dotC) < 1.0:     diffAngleC = arccos(dotC)
##        else:                   diffAngleC = pi
               
#        self.angleCurveA.plot(pos=(t,componentA))
#        self.angleCurveC.plot(pos=(t,componentC))

       
        for x in range(self.nSpinsX):
            for y in range(self.nSpinsY):
                xModXSpacing = x%self.stripeSpacingX
                yModYSpacing = y%self.stripeSpacingY

                if yModYSpacing == 0:
                    if xModXSpacing == 0:
                        self.xyzComponentGraph.pos[x] = spinLattice[x][y].getVectorPos() + spinLattice[x][y].getVectorAxis() - vector(1.0,-1.5,8.0) + vector(self.nSpinsX/2.0,0.0,0.0)
                        self.xComponentGraph.pos[x][2] = spinLattice[x][y].getVectorAxis()[0] - 4.0
                        self.yComponentGraph.pos[x][2] = spinLattice[x][y].getVectorAxis()[1]*5.0
                        self.zComponentGraph.pos[x][2] = spinLattice[x][y].getVectorAxis()[2] + 4.0
                    else:
                        self.xyzComponentGraph.pos[x] = spinLattice[x][y].getVectorPos() - vector(1.0,-1.5,8.0) + vector(self.nSpinsX/2.0,0.0,0.0)
                        self.xComponentGraph.pos[x][2] = -spinLattice[x][y].getVectorAxis()[0] - 4.0
                        self.yComponentGraph.pos[x][2] = spinLattice[x][y].getVectorAxis()[1]*5.0
                        self.zComponentGraph.pos[x][2] = -spinLattice[x][y].getVectorAxis()[2] + 4.0


    def toggleGraph(self):
        self.tvGraphs = (self.tvGraphs+1)%2

##        self.angleCurveA.visible = self.tvGraphs
##        self.xComponentGraph.visible = self.tvGraphs
##        self.angleCurveC.visible = self.tvGraphs


    def resetPlots(self):
        t = 0.000
        
##        self.angleCurveA.gcurve.visible = 0
##        self.xComponentGraph.curve.visible = 0
##        self.angleCurveC.gcurve.visible = 0
##
##        self.angleCurveA = gcurve(color=color.red, visible=self.tvGraphs)
##        self.xComponentGraph = curve(color=color.green, visible=self.tvGraphs)
##        self.angleCurveC = gcurve(color=color.blue, visible=self.tvGraphs)

